package model;

/**
 * 
 * Box class represents a slot in a {@link Board}: it can hide a mine and can be
 * selected: once selected, if it was hiding a mine, it will cause a
 * MineException. This box also supports a second kind of selection, through
 * wich it can be marked as a high-probability mine-hiding box
 * 
 * @author simone
 *
 */
public class Box {

	private boolean hasMine;
	private boolean hasBeenSelected = false;
	private boolean isMarked = false;

	/**
	 * Create a new Box istance, wich can hide a mine or not
	 * 
	 * @param hasMine
	 *            : true if this box will hide a mine, false otherwise
	 */
	public Box(boolean hasMine) {
		this.hasMine = hasMine;
	}

	/**
	 * Let you know whether or not this box is hiding a mine
	 * 
	 * @return: true if this box contains a mine, false otherwise
	 */
	public boolean hasMine() {
		return hasMine;
	}

	/**
	 * Let you know whether or not this box has already been selected
	 * 
	 * @return: true if this box has already been selected, false otherwise
	 */
	public boolean hasBeenSelected() {
		return hasBeenSelected;
	}

	/**
	 * Let you know whether or not this box has been marked
	 * 
	 * @return: true if this box hasBeenMarked, false otherwise
	 */
	public boolean isMarked() {
		return isMarked;
	}

	/**
	 * Mark this box as a mine-hiding one, without selecting it. This operation
	 * is reversable, since a marked box can be unmarked or even selected
	 */
	public void mark() {
		if (hasBeenSelected) {
			return;
		} else {
			isMarked = !isMarked;
		}
	}

	/**
	 * Tries to select the box. This operation is unreversable
	 * 
	 * @throws MineException
	 */
	public void select() throws MineException {
		isMarked = false;
		hasBeenSelected = true;
		if (hasMine) {
			throw new MineException();
		}
	}

}
